-- Deploy create_oauth_applications

BEGIN;

CREATE TABLE "oauth"."applications" (
  "id" SERIAL PRIMARY KEY,
  "user_id" INTEGER REFERENCES "users"("id") ON DELETE CASCADE,
  "name" CITEXT UNIQUE NOT NULL,
  "description" CITEXT NOT NULL,
  "client_id" UUID UNIQUE NOT NULL,
  "client_secret" TEXT NOT NULL DEFAULT gen_salt('bf'),
  "redirect_uri" TEXT NOT NULL,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "oauth_applications_client_id_index" ON "oauth"."applications" ("client_id");
CREATE INDEX "oauth_applications_user_id_index" ON "oauth"."applications" ("user_id");

CREATE TRIGGER "oauth_applications_created_at_trigger"
  BEFORE INSERT ON "oauth"."applications" FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "oauth_applications_updated_at_trigger"
  BEFORE UPDATE ON "oauth"."applications" FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

COMMIT;
