-- Deploy create_dynamic_counter_cache_triggers

BEGIN;

CREATE OR REPLACE FUNCTION "update_counter"(table_name text, column_name text, id integer, step integer)
  RETURNS VOID AS $$
    DECLARE
      conditions text := ' WHERE id = $1';
      updates text := column_name || '=' || column_name || '+' || step;
    BEGIN
      EXECUTE 'UPDATE ' || table_name || ' SET ' || updates || conditions
      USING id;
    END;
  $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION "counter_cache"()
  RETURNS trigger AS $$
    DECLARE
      table_name text := quote_ident(TG_ARGV[0]);
      counter_name text := quote_ident(TG_ARGV[1]);
      fk_name text := quote_ident(TG_ARGV[2]);
      fk_changed boolean := false;
      fk_value integer;
      record record;
    BEGIN
      IF TG_OP = 'UPDATE' THEN
        record := NEW;
        EXECUTE 'SELECT ($1).' || fk_name || ' != ' || '($2).' || fk_name
        INTO fk_changed
        USING OLD, NEW;
      END IF;

      IF TG_OP = 'DELETE' OR fk_changed THEN
        record := OLD;
        EXECUTE 'SELECT ($1).' || fk_name INTO fk_value USING record;
        PERFORM "update_counter"(table_name, counter_name, fk_value, -1);
      END IF;

      IF TG_OP = 'INSERT' OR fk_changed THEN
        record := NEW;
        EXECUTE 'SELECT ($1).' || fk_name INTO fk_value USING record;
        PERFORM "update_counter"(table_name, counter_name, fk_value, 1);
      END IF;

      RETURN record;
    END;
  $$ LANGUAGE plpgsql;


CREATE TRIGGER "update_continents_country_count"
  AFTER INSERT OR UPDATE OR DELETE ON "countries"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('continents', 'country_count', 'continent_id');


CREATE TRIGGER "update_countries_airport_count"
  AFTER INSERT OR UPDATE OR DELETE ON "airports"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('countries', 'airport_count', 'country_id');

CREATE TRIGGER "update_countries_port_count"
  AFTER INSERT OR UPDATE OR DELETE ON "ports"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('countries', 'port_count', 'country_id');

CREATE TRIGGER "update_countries_region_count"
  AFTER INSERT OR UPDATE OR DELETE ON "regions"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('countries', 'region_count', 'country_id');

CREATE TRIGGER "update_countries_spot_count"
  AFTER INSERT OR UPDATE OR DELETE ON "spots"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('countries', 'spot_count', 'country_id');

CREATE TRIGGER "update_countries_user_count"
  AFTER INSERT OR UPDATE OR DELETE ON "users"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('countries', 'user_count', 'country_id');


CREATE TRIGGER "update_regions_airport_count"
  AFTER INSERT OR UPDATE OR DELETE ON "airports"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('regions', 'airport_count', 'region_id');

CREATE TRIGGER "update_regions_port_count"
  AFTER INSERT OR UPDATE OR DELETE ON "ports"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('regions', 'port_count', 'region_id');

CREATE TRIGGER "update_regions_spot_count"
  AFTER INSERT OR UPDATE OR DELETE ON "spots"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('regions', 'spot_count', 'region_id');

CREATE TRIGGER "update_regions_user_count"
  AFTER INSERT OR UPDATE OR DELETE ON "users"
  FOR EACH ROW EXECUTE PROCEDURE "counter_cache"('regions', 'user_count', 'region_id');

COMMIT;
