-- Deploy burningswell_db:weather_countries_view to pg

BEGIN;

CREATE MATERIALIZED VIEW weather.countries AS
  SELECT row_number() OVER (ORDER BY "country_id", "variable_id", "valid_time") AS id,
         "country_id", "variable_id", "valid_time", max("reference_time") AS "reference_time", avg(value) AS value, min(value), max(value)
    FROM weather.spots AS w
    JOIN spots
      ON spots.id = w."spot_id"
   WHERE "country_id" IS NOT NULL
  GROUP BY "country_id", "variable_id", "valid_time"
  ORDER BY "country_id", "variable_id", "valid_time";

CREATE INDEX ON weather.countries (id);
CREATE INDEX ON weather.countries ("country_id");
CREATE INDEX ON weather.countries ("valid_time");

REFRESH MATERIALIZED VIEW weather.countries;

COMMIT;
