-- Deploy create_search_autocomplete_view

BEGIN;

CREATE MATERIALIZED VIEW search.autocomplete AS
     SELECT spots.id AS id,
            'spot' AS type,
            spots.name AS term,
            json_build_object(
              'continent', "json_embed_continent"(continents),
              'country', "json_embed_country"(countries),
              'region', "json_embed_region"(regions)
            ) AS _embedded
       FROM spots
       JOIN countries
         ON countries.id = spots."country_id"
       JOIN continents
         ON continents.id = countries."continent_id"
  LEFT JOIN regions
         ON regions.id = spots."region_id"
      UNION ALL
     SELECT countries.id AS id,
            'country' AS type,
            countries.name AS term,
            json_build_object(
              'continent', "json_embed_continent"(continents),
              'country', "json_embed_country"(countries)
            ) AS _embedded
       FROM countries
       JOIN continents
         ON continents.id = countries."continent_id"
      WHERE countries."spot_count" > 0
      UNION ALL
     SELECT regions.id AS id,
            'region' AS type,
            regions.name AS term,
            json_build_object(
              'continent', "json_embed_continent"(continents),
              'country', "json_embed_country"(countries)
            ) AS _embedded
       FROM regions
       JOIN countries
         ON countries.id = regions."country_id"
       JOIN continents
         ON continents.id = countries."continent_id"
      WHERE regions."spot_count" > 0;

COMMIT;
