-- Deploy burningswell_db:oauth_providers to pg

BEGIN;

CREATE TABLE oauth.providers (
  id SERIAL PRIMARY KEY,
  name CITEXT NOT NULL UNIQUE,
  description TEXT NOT NULL,
  "created_at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated_at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE TRIGGER "oauth_providers_before_insert_created_at"
  BEFORE INSERT ON oauth.providers FOR EACH ROW EXECUTE PROCEDURE "set_created_at"();

CREATE TRIGGER "oauth_providers_before_insert_updated_at"
  BEFORE INSERT ON oauth.providers FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

CREATE TRIGGER "oauth_providers_before_update_updated_at"
  BEFORE UPDATE ON oauth.providers FOR EACH ROW EXECUTE PROCEDURE "set_updated_at"();

INSERT INTO oauth.providers (name, description)
  VALUES ('facebook', 'Facebook');

INSERT INTO oauth.providers (name, description)
  VALUES ('google', 'Google');

INSERT INTO oauth.providers (name, description)
  VALUES ('linkedin', 'LinkedIn');

INSERT INTO oauth.providers (name, description)
  VALUES ('twitter', 'Twitter');

COMMIT;
