-- Deploy create_weather_spot_forecasts_view

BEGIN;

CREATE MATERIALIZED VIEW weather."spot_forecasts" AS
  SELECT *
    FROM weather."spots"
   WHERE "valid_time" >= date_trunc('day', clock_timestamp())
   ORDER BY "spot_id", "valid_time";

CREATE INDEX "weather_spot_forecasts_spot_id_valid_time" ON weather."spot_forecasts" ("spot_id", "valid_time");
CREATE UNIQUE INDEX "weather_spot_forecasts_spot_id_variable_id_valid_time" ON weather."spot_forecasts" ("spot_id", "variable_id", "valid_time");

COMMIT;
