-- Deploy burningswell-db:update-photos-dislikes-trigger to pg

BEGIN;

CREATE TRIGGER "update-photo-dislikes"
  AFTER INSERT OR UPDATE OR DELETE ON "dislikes"."photos"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('photos', 'dislikes', 'photo-id');

CREATE TRIGGER "update-photo-dislikes-truncate"
  AFTER TRUNCATE ON "dislikes"."photos"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "counter-cache"('photos', 'dislikes', 'photo-id');

COMMIT;
