-- Deploy burningswell-db:twitter-schema to pg

BEGIN;

CREATE SCHEMA twitter;

CREATE TABLE twitter.users (
  "id" TEXT PRIMARY KEY,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "profile" JSONB,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "twitter-users-user-id-idx" ON twitter.users ("user-id");

CREATE TRIGGER "twitter-users-before-insert-created-at"
  BEFORE INSERT ON twitter.users FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "twitter-users-before-insert-updated-at"
  BEFORE INSERT ON twitter.users FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

CREATE TRIGGER "twitter-users-before-update-updated-at"
  BEFORE UPDATE ON twitter.users FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
