-- Deploy burningswell-db:google-schema to pg

BEGIN;

CREATE SCHEMA google;

CREATE TABLE google.users (
  "id" TEXT PRIMARY KEY,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "profile" JSONB,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "google-users-user-id-idx" ON google.users ("user-id");

CREATE TRIGGER "google-users-before-insert-created-at"
  BEFORE INSERT ON google.users FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "google-users-before-insert-updated-at"
  BEFORE INSERT ON google.users FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

CREATE TRIGGER "google-users-before-update-updated-at"
  BEFORE UPDATE ON google.users FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
