-- Deploy create-ports-table

BEGIN;

CREATE TABLE "ports" (
  "id" SERIAL PRIMARY KEY,
  "country-id" INTEGER NOT NULL REFERENCES "countries"("id") ON DELETE CASCADE,
  "region-id" INTEGER REFERENCES "regions"("id") ON DELETE CASCADE,
  "name" CITEXT UNIQUE NOT NULL,
  "type" CITEXT NOT NULL,
  "website-url" TEXT,
  "location" GEOMETRY(POINT, 4326),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "ports-name-fulltext-index" ON "ports" USING gin(to_tsvector('english', "name"));
CREATE INDEX "ports-location-index" ON "ports" USING gist("location");

CREATE TRIGGER "ports-created-at-trigger"
  BEFORE INSERT ON "ports" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "ports-updated-at-trigger"
  BEFORE UPDATE ON "ports" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
