(ns burningswell.db.materialized-views
  (:require [burningswell.config.core :as config]
            [burningswell.db.connection :as db]
            [clojure.tools.logging :as log]
            [commandline.core :refer [print-help with-commandline]]
            [datumbazo.core :as sql :refer [concurrently with-connection]]
            [environ.core :refer [env]]))

(def views
  "The materialized views."
  [:search.autocomplete
   :weather.countries
   :weather.regions])

(defn run
  "Refresh materialized views."
  [config views & [opts]]
  (let [views (map keyword views)]
    (db/with-db [db config]
      (with-connection [db db]
        (doseq [view views]
          (log/infof "Refreshing materialized view %s." (name view))
          @(sql/refresh-materialized-view db view
             (sql/concurrently (:concurrently opts))))
        views))))

(defn -main [& args]
  (with-commandline [[opts args] args]
    [[h help "Print this help."]
     [c concurrently "Refresh the views concurrently."]]
    (if (:help opts)
      (print-help "materialized-views [OPTION...] [VIEWS,...]")
      (do (run (config/db env)
            (if (empty? args)
              views args)
            opts)))))
