-- Deploy burningswell-db:weather-countries-view to pg

BEGIN;

CREATE MATERIALIZED VIEW weather.countries AS
  SELECT row_number() OVER (ORDER BY "country-id", "variable-id", "valid-time") AS id,
         "country-id", "variable-id", "valid-time", max("reference-time") AS "reference-time", avg(value) AS value, min(value), max(value)
    FROM weather.spots AS w
    JOIN spots
      ON spots.id = w."spot-id"
   WHERE "country-id" IS NOT NULL
  GROUP BY "country-id", "variable-id", "valid-time"
  ORDER BY "country-id", "variable-id", "valid-time";

CREATE INDEX ON weather.countries (id);
CREATE INDEX ON weather.countries ("country-id");
CREATE INDEX ON weather.countries ("valid-time");

REFRESH MATERIALIZED VIEW weather.countries;

COMMIT;
