-- Deploy upsert-photo-like

BEGIN;

CREATE OR REPLACE FUNCTION "upsert-photo-like"("photo-id" integer, "user-id" integer, "like" boolean)
RETURNS void AS $$
#variable_conflict use_variable
BEGIN
  WITH upsert AS (UPDATE "photo-likes"
                     SET "like" = "like"
                   WHERE "photo-likes"."photo-id" = "photo-id"
                     AND "photo-likes"."user-id" = "user-id"
               RETURNING *)
    INSERT INTO "photo-likes" ("photo-id", "user-id", "like")
      SELECT "photo-id", "user-id", "like"
       WHERE NOT EXISTS (SELECT * FROM upsert);
END;
$$ LANGUAGE plpgsql;

COMMIT;
