-- Deploy burningswell-db:facebook-schema to pg

BEGIN;

CREATE SCHEMA facebook;

CREATE TABLE facebook.users (
  "id" TEXT PRIMARY KEY,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "profile" JSONB,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE INDEX "facebook-users-user-id-idx" ON facebook.users ("user-id");

CREATE TRIGGER "facebook-users-before-insert-created-at"
  BEFORE INSERT ON facebook.users FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "facebook-users-before-insert-updated-at"
  BEFORE INSERT ON facebook.users FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

CREATE TRIGGER "facebook-users-before-update-updated-at"
  BEFORE UPDATE ON facebook.users FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
