-- Deploy create-user-locations-table

BEGIN;

CREATE TABLE "user-locations" (
  "id" SERIAL PRIMARY KEY,
  "address-id" INTEGER REFERENCES "addresses"("id") ON DELETE SET NULL,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "location" GEOGRAPHY(POINT, 4326) NOT NULL,
  "last-seen-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "user-locations-location-index" ON "user-locations" USING gist(location);
CREATE INDEX "user-locations-user-id-index" ON "user-locations" ("user-id");

CREATE UNIQUE INDEX "user-locations-user-id-location-last-seen-at" ON "user-locations" ("user-id", "last-seen-at", "location");

CREATE TRIGGER "user-locations-created-at-trigger"
  BEFORE INSERT ON "user-locations" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "user-locations-updated-at-trigger"
  BEFORE UPDATE ON "user-locations" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
