-- Deploy add-user-to-role

BEGIN;

CREATE OR REPLACE FUNCTION "add-user-to-role"("user-id" integer, "role-id" integer)
RETURNS void AS $$
#variable_conflict use_variable
BEGIN
  INSERT INTO "roles-users" ("user-id", "role-id")
    SELECT "user-id", "role-id"
     WHERE NOT EXISTS
       (SELECT *
          FROM "roles-users"
         WHERE "roles-users"."user-id" = "user-id"
           AND "roles-users"."role-id" = "role-id");
END;
$$ LANGUAGE plpgsql;

COMMIT;
