-- Deploy create-dynamic-counter-cache-triggers

BEGIN;

CREATE OR REPLACE FUNCTION "update-counter"(table_name text, column_name text, id integer, step integer)  
  RETURNS VOID AS $$
    DECLARE
      conditions text := ' WHERE id = $1';
      updates text := column_name || '=' || column_name || '+' || step;
    BEGIN
      EXECUTE 'UPDATE ' || table_name || ' SET ' || updates || conditions
      USING id;
    END;
  $$ LANGUAGE plpgsql;

CREATE OR REPLACE FUNCTION "counter-cache"()  
  RETURNS trigger AS $$
    DECLARE
      table_name text := quote_ident(TG_ARGV[0]);
      counter_name text := quote_ident(TG_ARGV[1]);
      fk_name text := quote_ident(TG_ARGV[2]);
      fk_changed boolean := false;
      fk_value integer;
      record record;
    BEGIN
      IF TG_OP = 'UPDATE' THEN
        record := NEW;
        EXECUTE 'SELECT ($1).' || fk_name || ' != ' || '($2).' || fk_name
        INTO fk_changed
        USING OLD, NEW;
      END IF;

      IF TG_OP = 'DELETE' OR fk_changed THEN
        record := OLD;
        EXECUTE 'SELECT ($1).' || fk_name INTO fk_value USING record;
        PERFORM "update-counter"(table_name, counter_name, fk_value, -1);
      END IF;

      IF TG_OP = 'INSERT' OR fk_changed THEN
        record := NEW;
        EXECUTE 'SELECT ($1).' || fk_name INTO fk_value USING record;
        PERFORM "update-counter"(table_name, counter_name, fk_value, 1);
      END IF;

      RETURN record;
    END;
  $$ LANGUAGE plpgsql;


CREATE TRIGGER "update-continents-country-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "countries"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('continents', 'country-count', 'continent-id');


CREATE TRIGGER "update-countries-airport-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "airports"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('countries', 'airport-count', 'country-id');

CREATE TRIGGER "update-countries-port-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "ports"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('countries', 'port-count', 'country-id');

CREATE TRIGGER "update-countries-region-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "regions"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('countries', 'region-count', 'country-id');

CREATE TRIGGER "update-countries-spot-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "spots"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('countries', 'spot-count', 'country-id');

CREATE TRIGGER "update-countries-user-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "users"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('countries', 'user-count', 'country-id');


CREATE TRIGGER "update-regions-airport-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "airports"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('regions', 'airport-count', 'region-id');

CREATE TRIGGER "update-regions-port-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "ports"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('regions', 'port-count', 'region-id');

CREATE TRIGGER "update-regions-spot-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "spots"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('regions', 'spot-count', 'region-id');

CREATE TRIGGER "update-regions-user-count" 
  AFTER INSERT OR UPDATE OR DELETE ON "users"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('regions', 'user-count', 'region-id');

COMMIT;
