-- Deploy burningswell-db:counter-cache-truncate to pg

BEGIN;

CREATE OR REPLACE FUNCTION "counter-cache"()
  RETURNS trigger AS $$
    DECLARE
      table_name text := quote_ident(TG_ARGV[0]);
      counter_name text := quote_ident(TG_ARGV[1]);
      fk_name text := quote_ident(TG_ARGV[2]);
      fk_changed boolean := false;
      fk_value integer;
      record record;
    BEGIN

      IF TG_OP = 'UPDATE' THEN
        record := NEW;
        EXECUTE 'SELECT ($1).' || fk_name || ' != ' || '($2).' || fk_name
        INTO fk_changed
        USING OLD, NEW;
      END IF;

      IF TG_OP = 'DELETE' OR fk_changed THEN
        record := OLD;
        EXECUTE 'SELECT ($1).' || fk_name INTO fk_value USING record;
        PERFORM "update-counter"(table_name, counter_name, fk_value, -1);
      END IF;

      IF TG_OP = 'INSERT' OR fk_changed THEN
        record := NEW;
        EXECUTE 'SELECT ($1).' || fk_name INTO fk_value USING record;
        PERFORM "update-counter"(table_name, counter_name, fk_value, 1);
      END IF;

      IF TG_OP = 'TRUNCATE' THEN
        EXECUTE format('UPDATE %I SET %I = 0', table_name, counter_name);
        RETURN NEW;
      END IF;

      RETURN record;
    END;
  $$ LANGUAGE plpgsql;

COMMIT;
