-- Deploy create-weather-models-variables-table

BEGIN;

CREATE TABLE "weather"."models-variables" (
  "model-id" INTEGER NOT NULL REFERENCES "weather"."models"("id") ON DELETE CASCADE,
  "variable-id" INTEGER NOT NULL REFERENCES "weather"."variables"("id") ON DELETE CASCADE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "weather-models-variables-model-id-variable-id-index"
  ON "weather"."models-variables"("model-id", "variable-id");

CREATE TRIGGER "weather-models-variables-created-at-trigger"
  BEFORE INSERT ON "weather"."models-variables" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "weather-models-variables-updated-at-trigger"
  BEFORE UPDATE ON "weather"."models-variables" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
