-- Deploy create-time-zones-table

BEGIN;

CREATE TABLE "time-zones" (
  "id" SERIAL PRIMARY KEY,
  "natural-earth-id" INTEGER UNIQUE NOT NULL,
  "offset" INTEGER NOT NULL,
  "places" TEXT[] NOT NULL,
  "geom" GEOMETRY(MULTIPOLYGON, 4326),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "time-zones-geom-index" ON "time-zones" USING gist(geom);

CREATE TRIGGER "time-zones-created-at-trigger"
  BEFORE INSERT ON "time-zones" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "time-zones-updated-at-trigger"
  BEFORE UPDATE ON "time-zones" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
