-- Deploy update-country-spot-count

BEGIN;

CREATE OR REPLACE FUNCTION "update-country-spot-count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE countries
     SET "spot-count" = u.count
    FROM (SELECT countries.id, count(spots.id)
            FROM countries
       LEFT JOIN spots
              ON spots."country-id" = countries.id
        GROUP BY countries.id) AS u
   WHERE countries.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
