-- Deploy create-images-table

BEGIN;

CREATE TABLE "images" (
  "id" SERIAL PRIMARY KEY,
  "photo-id" INTEGER NOT NULL REFERENCES photos(id) ON DELETE CASCADE,
  "width" INTEGER NOT NULL,
  "height" INTEGER NOT NULL,
  "label" TEXT NOT NULL,
  "url" TEXT NOT NULL UNIQUE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "images-photo-id-index" ON "images" ("photo-id");
CREATE INDEX "images-photo-id-width-height-index" ON "images" ("photo-id", "width", "height");
CREATE INDEX "images-width-index" ON "images" ("width");
CREATE INDEX "images-width-height-index" ON "images" ("width", "height");
CREATE INDEX "images-height-index" ON "images" ("height");

CREATE TRIGGER "images-created-at-trigger"
  BEFORE INSERT ON images FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "images-updated-at-trigger"
  BEFORE UPDATE ON images FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
