-- Deploy create-spot-weather-3-hours-view

BEGIN;

CREATE MATERIALIZED VIEW "weather"."spot-weather-3-hours" AS
  SELECT "spot-id", "model-id", "variable-id",
         avg("value") AS "value",
         max("unit") AS "unit",
         max("valid-time") as "valid-time"
    FROM "weather"."spot-forecasts" AS "forecasts"
    JOIN "weather"."models"
      ON "weather"."models"."id" = "forecasts"."model-id"
    JOIN "weather"."variables"
      ON "weather"."variables"."id" = "forecasts"."variable-id"
GROUP BY "spot-id", "model-id", "variable-id",
         extract(year FROM "valid-time"),
         extract(month FROM "valid-time"),
         extract(day FROM "valid-time"),
         extract(hour FROM "valid-time") / 3;

COMMIT;
