-- Deploy burningswell-db:oauth-providers to pg

BEGIN;

CREATE TABLE oauth.providers (
  id SERIAL PRIMARY KEY,
  name CITEXT NOT NULL UNIQUE,
  description TEXT NOT NULL,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL,
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL
);

CREATE TRIGGER "oauth-providers-before-insert-created-at"
  BEFORE INSERT ON oauth.providers FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "oauth-providers-before-insert-updated-at"
  BEFORE INSERT ON oauth.providers FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

CREATE TRIGGER "oauth-providers-before-update-updated-at"
  BEFORE UPDATE ON oauth.providers FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

INSERT INTO oauth.providers (name, description)
  VALUES ('facebook', 'Facebook');

INSERT INTO oauth.providers (name, description)
  VALUES ('google', 'Google');

INSERT INTO oauth.providers (name, description)
  VALUES ('linkedin', 'LinkedIn');

COMMIT;
