-- Revert burningswell-db:drop-weather-spot-forecasts from pg

BEGIN;

CREATE MATERIALIZED VIEW weather."spot-forecasts" AS
  SELECT *
    FROM weather."spots"
   WHERE "valid-time" >= date_trunc('day', clock_timestamp())
   ORDER BY "spot-id", "valid-time";

CREATE INDEX "weather-spot-forecasts-spot-id-valid-time" ON weather."spot-forecasts" ("spot-id", "valid-time");
CREATE UNIQUE INDEX "weather-spot-forecasts-spot-id-variable-id-valid-time" ON weather."spot-forecasts" ("spot-id", "variable-id", "valid-time");

CREATE MATERIALIZED VIEW weather."spot-nowcasts" AS
  SELECT DISTINCT ON ("spot-id", "variable-id") *
    FROM weather."spot-forecasts"
   WHERE "valid-time" >= clock_timestamp()
   ORDER BY "spot-id", "variable-id", "valid-time";

CREATE INDEX "weather-spot-nowcasts-spot-id" ON weather."spot-nowcasts" ("spot-id");
CREATE UNIQUE INDEX "weather-spot-nowcasts-spot-id-variable-id-valid-time" ON weather."spot-nowcasts" ("spot-id", "variable-id", "valid-time");

COMMIT;
