-- Deploy create-weather-variables-table

BEGIN;

CREATE TABLE "weather"."variables" (
  "id" SERIAL PRIMARY KEY,
  "name" CITEXT NOT NULL,
  "description" TEXT NOT NULL,
  "unit" TEXT NOT NULL,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "weather-variables-name-fulltext-index" ON "weather"."variables" USING gin(to_tsvector('english', "name"));

CREATE TRIGGER "weather-variables-created-at-trigger"
  BEFORE INSERT ON "weather"."variables" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "weather-variables-updated-at-trigger"
  BEFORE UPDATE ON "weather"."variables" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
