-- Deploy create-ratings-table

BEGIN;

CREATE TABLE "ratings" (
  "id" SERIAL PRIMARY KEY,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "spot-id" INTEGER NOT NULL REFERENCES "spots"("id") ON DELETE CASCADE,
  "rating" INTEGER NOT NULL CONSTRAINT "valid-rating" CHECK ("rating" > 0 AND "rating" < 6),
  "rated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "ratings-spot-id-index" ON "ratings" ("spot-id");
CREATE UNIQUE INDEX "ratings-user-id-spot-id-rated-at-index" ON "ratings" ("user-id", "spot-id", "rated-at");

CREATE TRIGGER "ratings-created-at-trigger"
  BEFORE INSERT ON "ratings" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "ratings-updated-at-trigger"
  BEFORE UPDATE ON "ratings" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
