-- Deploy create-photo-label-scores-table

BEGIN;

CREATE TABLE "photo-label-scores" (
  "id" SERIAL PRIMARY KEY,
  "photo-id" INTEGER NOT NULL REFERENCES "photos" (id) ON DELETE CASCADE,
  "photo-label-id" INTEGER NOT NULL REFERENCES "photo-labels" (id) ON DELETE CASCADE,
  "score" DOUBLE PRECISION NOT NULL CHECK ("score" >= 0.0 AND "score" <= 1.0),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE UNIQUE INDEX "photo-label-scores-unique-index" ON "photo-label-scores" ("photo-label-id", "photo-id");

CREATE TRIGGER "photo-label-scores-created-at-trigger"
  BEFORE INSERT ON "photo-label-scores" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "photo-label-scores-updated-at-trigger"
  BEFORE UPDATE ON "photo-label-scores" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
