-- Deploy update-continent-airport-count

BEGIN;

CREATE OR REPLACE FUNCTION "update-continent-airport-count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE continents
     SET "airport-count" = u.count
    FROM (SELECT continents.id, count(airports.id)
            FROM continents
       LEFT JOIN countries
              ON countries."continent-id" = continents.id
       LEFT JOIN airports
              ON airports."country-id" = countries.id
        GROUP BY continents.id) AS u
   WHERE continents.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
