-- Deploy burningswell-db:update-photos-likes-trigger to pg

BEGIN;

CREATE TRIGGER "update-photo-likes"
  AFTER INSERT OR UPDATE OR DELETE ON "likes"."photos"
  FOR EACH ROW EXECUTE PROCEDURE "counter-cache"('photos', 'likes', 'photo-id');

CREATE TRIGGER "update-photo-likes-truncate"
  AFTER TRUNCATE ON "likes"."photos"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "counter-cache"('photos', 'likes', 'photo-id');

COMMIT;
