-- Deploy spot-count-trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update-spot-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-spot-count"();
  PERFORM "update-country-spot-count"();
  PERFORM "update-region-spot-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-spot-counts-on-delete-trigger"
  AFTER DELETE ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-spot-counts"();

CREATE TRIGGER "update-spot-counts-on-insert-trigger"
  AFTER INSERT ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-spot-counts"();

CREATE TRIGGER "update-spot-counts-on-update-trigger"
  AFTER UPDATE ON "spots"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-spot-counts"();

COMMIT;
