-- Deploy create-airports-table

BEGIN;

CREATE TABLE airports (
  "id" SERIAL PRIMARY KEY,
  "country-id" INTEGER NOT NULL REFERENCES countries(id) ON DELETE CASCADE,
  "region-id" INTEGER REFERENCES regions(id) ON DELETE CASCADE,
  "name" CITEXT NOT NULL,
  "gps-code" CITEXT UNIQUE NOT NULL,
  "iata-code" CITEXT UNIQUE NOT NULL,
  "wikipedia-url" TEXT,
  "location" GEOMETRY(POINT, 4326),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX airports_name_fulltext_index ON airports USING gin(to_tsvector('english', name));
CREATE INDEX airports_location_index ON airports USING gist(location);

CREATE TRIGGER airports_created_at_trigger
  BEFORE INSERT ON airports FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER airports_updated_at_trigger
  BEFORE UPDATE ON airports FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
