(ns burningswell.db.time-zones
  (:require [datumbazo.table :as t]
            [datumbazo.core :as sql]))

(t/deftable time-zones
  "The time zones table."
  (t/column :created-at :timestamp :not-null? true)
  (t/column :geom :geography)
  (t/column :id :integer :primary-key? true)
  (t/column :natural-earth-id :integer)
  (t/column :offset :integer)
  (t/column :places :text) ;; TODO array
  (t/column :updated-at :timestamp :not-null? true))

;; (defn- select-all [db & [opts]]
;;   (let [{:keys [page per-page]} opts]
;;     (select db [:time-zones.id
;;                 :time-zones.natural-earth-id
;;                 :time-zones.offset
;;                 :time-zones.places
;;                 :time-zones.created-at
;;                 :time-zones.updated-at]
;;       (from :time-zones)
;;       (paginate page per-page))))

;; (s/defn all :- [TimeZone]
;;   "Return all time zones in `db`."
;;   [db :- Database & [opts]]
;;   @(select-all db opts))

;; (s/defn by-id :- (s/maybe TimeZone)
;;   "Return the time zone in `db` by `id`."
;;   [db :- Database id :- s/Int & [opts]]
;;   (first @(compose
;;            (select-all db opts)
;;            (where `(= :time-zones.id (cast ~id :integer))))))

(defn by-location
  "Return the time zone in `db` for `location`."
  [db location & [opts]]
  (first @(sql/select db [:*]
            (sql/from :time-zones)
            (sql/where `(st_intersects
                         :time-zones.geom
                         (cast ~location :geography))))))
