-- Deploy create-oauth-access-grants

BEGIN;

CREATE TABLE "oauth"."access-grants" (
  "id" SERIAL PRIMARY KEY,
  "application-id" INTEGER NOT NULL REFERENCES oauth.applications(id) ON DELETE CASCADE,
  "user-id" INTEGER NOT NULL REFERENCES users(id) ON DELETE CASCADE,
  "token" TEXT UNIQUE NOT NULL,
  "redirect-uri" TEXT NOT NULL,
  "expires-at" TIMESTAMP WITH TIME ZONE,
  "revoked-at" TIMESTAMP WITH TIME ZONE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT clock_timestamp()
);

CREATE INDEX "oauth-access-grants-user-id-index" ON "oauth"."access-grants" ("user-id");

CREATE TRIGGER "oauth-access-grants-created-at-trigger"
  BEFORE INSERT ON "oauth"."access-grants" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "oauth-access-grants-updated-at-trigger"
  BEFORE UPDATE ON "oauth"."access-grants" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
