(ns burningswell.db.weather.models
  (:require [datumbazo.table :as t]))

(t/deftable models
  "The weather models table."
  (t/table :weather.models)
  (t/column :created-at :timestamp :not-null? true)
  (t/column :description :text)
  (t/column :dods :text)
  (t/column :id :integer :primary-key? true)
  (t/column :latest-reference-time :timestamp)
  (t/column :name :citext :unique? true)
  (t/column :pattern :text)
  (t/column :res-x :double)
  (t/column :res-y :double)
  (t/column :updated-at :timestamp :not-null? true))

(defn akw
  "Return the Regional Alaska Waters weather model."
  [db]
  (by-name db "akw"))

(defn nww3
  "Return the Global Wave Watch III weather model."
  [db]
  (by-name db "nww3"))

;; (defn- select-all [db & [opts]]
;;   (select db [:weather.models.id
;;               :weather.models.name
;;               :weather.models.description
;;               :weather.models.pattern
;;               :weather.models.latest-reference-time
;;               :weather.models.dods
;;               :weather.models.res-x
;;               :weather.models.res-y
;;               :weather.models.created-at
;;               :weather.models.updated-at]
;;     (from :weather.models)
;;     (paginate (:page opts) (:per-page opts))
;;     (order-by :weather.models.name)))

;; (s/defn all :- [WeatherModel]
;;   "Return all weather models in `db`."
;;   [db :- Database]
;;   @(select-all db))

;; (s/defn by-id :- (s/maybe WeatherModel)
;;   "Return the weather model in `db` by `id`."
;;   [db :- Database id :- s/Int]
;;   (first @(compose
;;            (select-all db)
;;            (where `(= :weather.models.id (cast ~id :integer))))))

;; (s/defn by-name :- (s/maybe WeatherModel)
;;   "Return the weather model in `db` by `name`."
;;   [db :- Database name :- s/Str]
;;   (first @(compose
;;            (select-all db)
;;            (where `(= :weather.models.name ~name)))))

;; (s/defn by-names :- [WeatherModel]
;;   "Return the weather models in `db` with a name in `names`."
;;   [db :- Database names :- [s/Str]]
;;   @(compose
;;     (select-all db)
;;     (where `(in :weather.models.name ~(seq names)))))

;; (s/defn by-names-or-all :- [WeatherModel]
;;   "Return the weather models in `db` with a name in `names`, or all
;;   weather models if `names` is empty."
;;   [db :- Database names :- [s/Str]]
;;   (if (empty? names)
;;     (all db) (by-names db names)))

;; (s/defn by-variable :- [WeatherModel]
;;   "Return the weather models in `db` for `variable`."
;;   [db :- Database variable :- WeatherVariable]
;;   @(compose
;;     (select-all db)
;;     (join :weather.models-variables.model-id :weather.models.id)
;;     (where `(= :weather.models-variables.variable-id
;;                ~(:id variable)))))
