(ns burningswell.db.main
  (:gen-class)
  (:require [burningswell.db.backup :as backup]
            [burningswell.db.fixtures :as fixtures]))

(defn- exit [message]
  (println (str "bs-db: " message))
  (System/exit 1))

(defn -main [& [cmd & args]]
  (case (keyword cmd)
    :backup (apply backup/-main args)
    :fixtures (apply fixtures/-main args)
    nil (exit "No command given.")
    (exit (format "Unknown command: %s." cmd))))
