-- Deploy create-search-autocomplete-view

BEGIN;

CREATE MATERIALIZED VIEW search.autocomplete AS
     SELECT spots.id AS id,
            'spot' AS type,
            spots.name AS term,
            json_build_object(
              'continent', "json-embed-continent"(continents),
              'country', "json-embed-country"(countries),
              'region', "json-embed-region"(regions)
            ) AS _embedded
       FROM spots
       JOIN countries
         ON countries.id = spots."country-id"
       JOIN continents
         ON continents.id = countries."continent-id"
  LEFT JOIN regions
         ON regions.id = spots."region-id"
      UNION ALL
     SELECT countries.id AS id,
            'country' AS type,
            countries.name AS term,
            json_build_object(
              'continent', "json-embed-continent"(continents),
              'country', "json-embed-country"(countries)
            ) AS _embedded
       FROM countries
       JOIN continents
         ON continents.id = countries."continent-id"
      WHERE countries."spot-count" > 0
      UNION ALL
     SELECT regions.id AS id,
            'region' AS type,
            regions.name AS term,
            json_build_object(
              'continent', "json-embed-continent"(continents),
              'country', "json-embed-country"(countries)
            ) AS _embedded
       FROM regions
       JOIN countries
         ON countries.id = regions."country-id"
       JOIN continents
         ON continents.id = countries."continent-id"
      WHERE regions."spot-count" > 0;

COMMIT;
