-- Deploy create-oauth-access-tokens

BEGIN;

CREATE TABLE "oauth"."access-tokens" (
  "id" SERIAL PRIMARY KEY,
  "application-id" INTEGER NOT NULL REFERENCES "oauth"."applications"("id") ON DELETE CASCADE,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "access-token" TEXT UNIQUE NOT NULL,
  "refresh-token" TEXT UNIQUE NOT NULL,
  "expires-at" TIMESTAMP WITH TIME ZONE,
  "revoked-at" TIMESTAMP WITH TIME ZONE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "oauth-access-tokens-application-id-index" ON "oauth"."access-tokens" ("application-id");
CREATE INDEX "oauth-access-tokens-user-id-index" ON "oauth"."access-tokens" ("user-id");

CREATE TRIGGER "oauth-access-tokens-created-at-trigger"
  BEFORE INSERT ON "oauth"."access-tokens" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "oauth-access-tokens-updated-at-trigger"
  BEFORE UPDATE ON "oauth"."access-tokens" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
