-- Deploy create-sessions-table

BEGIN;

CREATE TABLE "sessions" (
  "id" SERIAL PRIMARY KEY,
  "user-id" INTEGER NOT NULL REFERENCES "users"("id") ON DELETE CASCADE,
  "spot-id" INTEGER NOT NULL REFERENCES "spots"("id") ON DELETE CASCADE,
  "started-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now() - interval '1 hour',
  "stopped-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "rating" INTEGER NOT NULL CONSTRAINT "valid-rating" CHECK ("rating" > 0 AND "rating" < 6),
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "sessions-user-id-index" ON "sessions" ("user-id");
CREATE INDEX "sessions-spot-id-index" ON "sessions" ("spot-id");

CREATE TRIGGER "sessions-created-at-trigger"
  BEFORE INSERT ON "sessions" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "sessions-updated-at-trigger"
  BEFORE UPDATE ON "sessions" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
