-- Revert delete-images

BEGIN;

DROP TABLE "photos-spots";

ALTER TABLE "photos" DROP COLUMN "content-length";
ALTER TABLE "photos" DROP COLUMN "content-md5";
ALTER TABLE "photos" DROP COLUMN "content-type";
ALTER TABLE "photos" DROP COLUMN "flickr-owner-id";
ALTER TABLE "photos" DROP COLUMN "flickr-owner-name";
ALTER TABLE "photos" DROP COLUMN "flickr-owner-url";
ALTER TABLE "photos" DROP COLUMN "flickr-url";
ALTER TABLE "photos" DROP COLUMN "height";
ALTER TABLE "photos" DROP COLUMN "original-url";
ALTER TABLE "photos" DROP COLUMN "s3-key";
ALTER TABLE "photos" DROP COLUMN "status";
ALTER TABLE "photos" DROP COLUMN "width";

ALTER TABLE "photos" ADD COLUMN "spot-id" INTEGER REFERENCES spots(id) ON DELETE CASCADE;
CREATE INDEX "photos-spot-id-index" ON "photos" ("spot-id");

CREATE TABLE "images" (
  "id" SERIAL PRIMARY KEY,
  "photo-id" INTEGER NOT NULL REFERENCES photos(id) ON DELETE CASCADE,
  "width" INTEGER NOT NULL,
  "height" INTEGER NOT NULL,
  "label" TEXT NOT NULL,
  "url" TEXT NOT NULL UNIQUE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "images-photo-id-index" ON "images" ("photo-id");
CREATE INDEX "images-photo-id-width-height-index" ON "images" ("photo-id", "width", "height");
CREATE INDEX "images-width-index" ON "images" ("width");
CREATE INDEX "images-width-height-index" ON "images" ("width", "height");
CREATE INDEX "images-height-index" ON "images" ("height");

CREATE TRIGGER "images-created-at-trigger"
  BEFORE INSERT ON images FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "images-updated-at-trigger"
  BEFORE UPDATE ON images FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

CREATE OR REPLACE VIEW "thumbnails" AS
  SELECT DISTINCT ON ("spot-id") "photos".*, "images"."width", "images"."height", "images"."url"
    FROM "images"
    JOIN "photos"
      ON "photos"."id" = "images"."photo-id"
   WHERE "width" >= 200
     AND "height" >= 100
ORDER BY "spot-id", "updated-at";

COMMIT;
