-- Deploy recreate-images

BEGIN;

ALTER TABLE "photos" DROP COLUMN "flickr-url";
ALTER TABLE "photos" DROP COLUMN "content-length";
ALTER TABLE "photos" DROP COLUMN "content-md5";
ALTER TABLE "photos" DROP COLUMN "content-type";
ALTER TABLE "photos" DROP COLUMN "s3-key";
ALTER TABLE "photos" DROP COLUMN "width";
ALTER TABLE "photos" DROP COLUMN "height";
ALTER TABLE "photos" RENAME COLUMN "original-url" TO "url";

CREATE TABLE "images" (
  "id" SERIAL PRIMARY KEY,
  "photo-id" INTEGER NOT NULL REFERENCES photos(id) ON DELETE CASCADE,
  "content-disposition" TEXT NOT NULL,
  "content-length" INTEGER NOT NULL CHECK ("content-length" >= 0),
  "content-md5" TEXT NOT NULL,
  "content-type" TEXT NOT NULL,
  "width" INTEGER NOT NULL CHECK ("width" >= 0),
  "height" INTEGER NOT NULL CHECK ("height" >= 0),
  "label" TEXT NOT NULL,
  "s3-key" TEXT NOT NULL UNIQUE,
  "url" TEXT NOT NULL UNIQUE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "images-photo-id-index" ON "images" ("photo-id");
CREATE UNIQUE INDEX "images-photo-id-label-index" ON "images" ("photo-id", "label");
CREATE UNIQUE INDEX "images-url-index" ON "images" ("url");
CREATE UNIQUE INDEX "images-s3-key-index" ON "images" ("s3-key");
CREATE INDEX "images-width-index" ON "images" ("width");
CREATE INDEX "images-width-height-index" ON "images" ("width", "height");
CREATE INDEX "images-height-index" ON "images" ("height");

CREATE TRIGGER "images-created-at-trigger"
  BEFORE INSERT ON images FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "images-updated-at-trigger"
  BEFORE UPDATE ON images FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
