-- Deploy create-weather-datasets

BEGIN;

CREATE TABLE "weather"."datasets" (
  "id" SERIAL PRIMARY KEY,
  "model-id" INTEGER NOT NULL REFERENCES "weather"."models"("id") ON DELETE CASCADE,
  "variable-id" INTEGER NOT NULL REFERENCES "weather"."variables"("id") ON DELETE CASCADE,
  "reference-time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "valid-time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "das" TEXT NOT NULL,
  "dds" TEXT NOT NULL,
  "dods" TEXT NOT NULL,
  "filename" TEXT UNIQUE,
  "filesize" integer,
  "rast" raster,
  "download-started-at" TIMESTAMP WITH TIME ZONE,
  "download-finished-at" TIMESTAMP WITH TIME ZONE,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "weather-datasets-model-id-variable-id-valid-time-index" ON "weather"."datasets" ("model-id", "variable-id", "valid-time");
CREATE UNIQUE INDEX "weather-datasets-model-id-variable-id-filename-index" ON "weather"."datasets" ("model-id", "variable-id", "filename");
CREATE INDEX "weather-datasets-rast-idx" ON "weather"."datasets" USING GIST (ST_ConvexHull("rast"));

CREATE TRIGGER "weather-datasets-created-at-trigger"
  BEFORE INSERT ON "weather"."datasets" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "weather-datasets-updated-at-trigger"
  BEFORE UPDATE ON "weather"."datasets" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
