-- Deploy create-weather-forecasts-table

BEGIN;

CREATE TABLE "weather"."forecasts" (
  "id" SERIAL PRIMARY KEY,
  "spot-id" INTEGER NOT NULL REFERENCES "spots"("id") ON DELETE CASCADE,
  "model-id" INTEGER NOT NULL REFERENCES "weather"."models"("id") ON DELETE CASCADE,
  "variable-id" INTEGER NOT NULL REFERENCES "weather"."variables"("id") ON DELETE CASCADE,
  "reference-time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "valid-time" TIMESTAMP WITH TIME ZONE NOT NULL,
  "value" FLOAT,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE UNIQUE INDEX "weather-forecasts-spot-id-variable-id-valid-time-index" ON "weather"."forecasts" ("spot-id", "variable-id", "valid-time");
CREATE INDEX "weather-forecasts-spot-id-valid-time-index" ON "weather"."forecasts" ("spot-id", "valid-time");

CREATE TRIGGER "weather-forecasts-created-at-trigger"
  BEFORE INSERT ON "weather"."forecasts" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "weather-forecasts-updated-at-trigger"
  BEFORE UPDATE ON "weather"."forecasts" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
