-- Deploy us-value

BEGIN;

CREATE OR REPLACE FUNCTION "us-value"(value DOUBLE PRECISION, unit TEXT)
RETURNS DOUBLE PRECISION AS $$
BEGIN
  CASE unit
  WHEN 'k' THEN
    RETURN "kelvin->fahrenheit"(value);
  WHEN 'm' THEN
    RETURN "meter->feet"(value);
  WHEN 'm/s' THEN
    RETURN "m/s->miles/h"(value);
  ELSE
    RETURN value;
  END CASE;
END;
$$ LANGUAGE plpgsql IMMUTABLE STRICT;

COMMIT;
