-- Deploy update-region-airport-count

BEGIN;

CREATE OR REPLACE FUNCTION "update-region-airport-count"() RETURNS int AS $$
DECLARE
  row_count int := 0;
BEGIN
  UPDATE regions
     SET "airport-count" = u.count
    FROM (SELECT regions.id, count(regions.id)
            FROM regions
       LEFT JOIN airports
              ON airports."region-id" = regions.id
        GROUP BY regions.id) AS u
   WHERE regions.id = u.id;
  GET DIAGNOSTICS row_count = ROW_COUNT;
  RETURN row_count;
END;
$$ LANGUAGE plpgsql;

COMMIT;
