(ns burningswell.db.materialized-views
  (:require [burningswell.config.core :as config]
            [burningswell.db.connection :as db]
            [burningswell.db.search :as search]
            [burningswell.db.weather :as weather]
            [clojure.tools.logging :as log]
            [commandline.core :refer [print-help with-commandline]]
            [datumbazo.core :refer [concurrently refresh-materialized-view]]
            [environ.core :refer [env]]))

(def views
  "The materialized views."
  [:search.autocomplete
   :weather.spot-weather-3-hours])

(defn run
  "Refresh materialized views."
  [config views & [opts]]
  (db/with-db [db config]
    (doseq [view (map keyword views)]
      (log/infof "Refreshing materialized view %s." (name view))
      @(refresh-materialized-view
        db view (concurrently (:concurrently opts))))))

(defn -main [& args]
  (with-commandline [args args]
    [[h help "Print this help."]
     [c concurrently "Refresh the views concurrently."]]
    (when help
      (print-help "materialized-views [OPTION...] [VIEWS,...]")
      (System/exit 0))
    (run (config/db env)
      (if (empty? args) views args)
      {:concurrently concurrently})))
