-- Deploy create-users-table

BEGIN;

CREATE TABLE "users" (
  "id" SERIAL PRIMARY KEY,
  "country-id" INTEGER REFERENCES "countries"("id") ON DELETE CASCADE,
  "region-id" INTEGER REFERENCES "regions"("id") ON DELETE CASCADE,
  "username" CITEXT NOT NULL UNIQUE,
  "email" CITEXT UNIQUE,
  "name" TEXT,
  "first-name" TEXT,
  "last-name" TEXT,
  "crypted-password" TEXT,
  "location" GEOMETRY(POINT, 4326),
  "locale" TEXT,
  "facebook-id" TEXT UNIQUE,
  "facebook-url" TEXT UNIQUE,
  "google-id" TEXT UNIQUE,
  "google-url" TEXT,
  "twitter-id" TEXT UNIQUE,
  "twitter-url" TEXT,
  "created-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now(),
  "updated-at" TIMESTAMP WITH TIME ZONE NOT NULL DEFAULT now()
);

CREATE INDEX "users-username-fulltext-index" ON "users" USING gin(to_tsvector('english', "username"));

CREATE TRIGGER "users-created-at-trigger"
  BEFORE INSERT ON "users" FOR EACH ROW EXECUTE PROCEDURE "set-created-at"();

CREATE TRIGGER "users-updated-at-trigger"
  BEFORE UPDATE ON "users" FOR EACH ROW EXECUTE PROCEDURE "set-updated-at"();

COMMIT;
