(ns burningswell.db.sessions
  (:refer-clojure :exclude [distinct group-by update])
  (:require [clj-time.core :refer [now]]
            [clojure.java.jdbc :as jdbc]
            [datumbazo.core :refer :all]))

(deftable sessions
  "The surf sessions database table."
  (column :id :serial :primary-key? true)
  (column :user-id :integer :not-null? true :references :users/id)
  (column :spot-id :integer :not-null? true :references :spots/id)
  (column :started-at :timestamp-with-time-zone :not-null? true)
  (column :stopped-at :timestamp-with-time-zone :not-null? true)
  (column :rating :integer :not-null? true)
  (column :created-at :timestamp-with-time-zone
          :not-null? true :default '(now))
  (column :updated-at :timestamp-with-time-zone
          :not-null? true :default '(now)))

(defquery sessions-by-spot
  "Returns the sessions for the given spot."
  [db spot & [opts]]
  (let [{:keys [page per-page]} opts]
    (select db [:sessions.*]
      (from :sessions)
      (where `(= :spot-id ~(:id spot)))
      (paginate page per-page)
      (order-by :started-at))))
