-- Deploy user-count-trigger

BEGIN;

CREATE OR REPLACE FUNCTION "update-user-counts"() RETURNS trigger AS $$
BEGIN
  PERFORM "update-continent-user-count"();
  PERFORM "update-country-user-count"();
  PERFORM "update-region-user-count"();
  RETURN NULL;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-user-counts-on-delete-trigger"
  AFTER DELETE ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-user-counts"();

CREATE TRIGGER "update-user-counts-on-insert-trigger"
  AFTER INSERT ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-user-counts"();

CREATE TRIGGER "update-user-counts-on-update-trigger"
  AFTER UPDATE ON "users"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-user-counts"();

COMMIT;
