-- Deploy update-photo-likes

BEGIN;

CREATE FUNCTION "update-photo-likes"() RETURNS trigger AS $$
BEGIN
  IF (TG_OP = 'DELETE' AND OLD.like) THEN
    UPDATE "photos" SET "likes" = "likes" - 1 WHERE "id" = OLD."photo-id";
    RETURN OLD;
  ELSIF (TG_OP = 'DELETE' AND NOT OLD.like) THEN
    UPDATE "photos" SET "dislikes" = "dislikes" - 1 WHERE "id" = OLD."photo-id";
    RETURN OLD;
  ELSIF (TG_OP = 'INSERT' AND NEW.like) THEN
    UPDATE "photos" SET "likes" = "likes" + 1 WHERE "id" = NEW."photo-id";
    RETURN NEW;
  ELSIF (TG_OP = 'INSERT' AND NOT NEW.like) THEN
    UPDATE "photos" SET "dislikes" = "dislikes" + 1 WHERE "id" = NEW."photo-id";
    RETURN NEW;
  ELSIF (TG_OP = 'TRUNCATE') THEN
    UPDATE "photos"
       SET "likes" = 0, "dislikes" = 0;
    RETURN NEW;
  ELSIF (TG_OP = 'UPDATE' AND OLD.like = NEW.like) THEN
    RETURN NEW;
  ELSIF (TG_OP = 'UPDATE' AND NEW.like) THEN
    UPDATE "photos"
       SET "likes" = "likes" + 1, "dislikes" = "dislikes" - 1
     WHERE "id" = NEW."photo-id";
    RETURN NEW;
  ELSIF (TG_OP = 'UPDATE' AND NOT NEW.like) THEN
    UPDATE "photos"
       SET "likes" = "likes" - 1, "dislikes" = "dislikes" + 1
     WHERE "id" = NEW."photo-id";
    RETURN NEW;
  END IF;
END;
$$ LANGUAGE plpgsql;

CREATE TRIGGER "update-photo-likes-on-delete-trigger"
  AFTER DELETE ON "photo-likes"
  FOR EACH ROW
  EXECUTE PROCEDURE "update-photo-likes"();

CREATE TRIGGER "update-photo-likes-on-insert-trigger"
  AFTER INSERT ON "photo-likes"
  FOR EACH ROW
  EXECUTE PROCEDURE "update-photo-likes"();

CREATE TRIGGER "update-photo-likes-on-truncate-trigger"
  AFTER TRUNCATE ON "photo-likes"
  FOR EACH STATEMENT
  EXECUTE PROCEDURE "update-photo-likes"();

CREATE TRIGGER "update-photo-likes-on-update-trigger"
  AFTER UPDATE ON "photo-likes"
  FOR EACH ROW
  EXECUTE PROCEDURE "update-photo-likes"();

COMMIT;
